DIM Freq(1000) ' Array to Hold Data (Frequency (Hz))
DIM Bias(1000) ' Array to Hold Data (Bias (V or mA))
DIM Ampl(1000) ' Array to Hold Data (Amplitude (mV or mA))
DIM Tim(1000) ' Array to Hold Data (Time (Seconds))
DIM Real(1000) ' Array to Hold Data (Real (a or Z'))
DIM Imag(1000) ' Array to Hold Data (Imaginary (b or Z''))
DIM GD(1000) ' Array to Hold Data (Group Delay)
DIM Errs(1000) ' Array to Hold Data (Error Values)
DIM Range(1000) ' Array to Hold Data (Current Range Values)
DIM Comments$(11)                            ' Array to Hold File Header
DIM No                                      ' Number for Data Points in File

CLS
PRINT "PROGRAM: LOADZ"
PRINT
PRINT "This program loads a ZPlotW/Z60W Data File and"
PRINT "saves the data in another file."
PRINT
PRINT
INPUT "Enter The Name of the Data File to Load: ", In.File$

IF LEN(In.File$) = 0 THEN GOTO Prog.End    ' If No File Name Given, Exit Program


OPEN In.File$ FOR INPUT AS #1

FOR i = 1 TO 11
  LINE INPUT #1, Comments$(i)                   ' Read In Header Text
NEXT i

No = VAL(Comments$(10)) 'Extract the No. of Data Points from line #10

i = 0
WHILE NOT EOF(1)
i = i + 1     ' Read In Data Points
  INPUT #1, Freq(i), Bias(i), Ampl(i), Tim(i)
  INPUT #1, Real(i), Imag(i), GD(i), Errs(i), Range(i)
WEND
No = i

CLOSE #1


PRINT
PRINT
PRINT "File Header:"
FOR i = 1 TO 11
  PRINT Comments$(i)                       ' Display Header Text
NEXT i

'***************************************************
'*   If you wish to modify the data,               *
'*   or perform some calculations on the data,     *
'*   do so here.                                   *
'*                                                 *
'*   The following example would multiply all of   *
'*   real and imaginary values by 100              *
'*                                                 *
'*   FOR i = 1 TO No                               *
'*     Real(i) = Real(i) * 100                     *
'*     Imag(i) = Imag(i) * 100                     *
'*   NEXT i                                        *
'***************************************************







PRINT
PRINT
INPUT "Enter The Name of the Data File to Save: ", Out.File$

IF LEN(Out.File$) = 0 THEN GOTO Prog.End    ' If No File Name Given, Exit Program


OPEN Out.File$ FOR OUTPUT AS #1
FOR i = 1 TO 11
  PRINT #1, Comments$(i)                   ' Write Comment Text to File
NEXT i

FOR i = 1 TO No                            ' Write Date Points to File
  PRINT #1, USING "+#.####^^^^_,+#.####^^^^_,+#.####^^^^_,+#.####^^^^_,"; Freq(i); Bias(i); Ampl(i); Tim(i);
  PRINT #1, USING "+#.####^^^^_,+#.####^^^^_,+#.####^^^^_,+####_,+####"; Real(i); Imag(i); GD(i); Errs(i); Range(i)
NEXT i
CLOSE #1

Prog.End:

END

